Option Explicit

Const scriptName = "Toggle Image Preview"
Const scriptVer = "1.1.0"

'Toggle the annoying Preview shell extension
' Michael Miller - http://www.esglabs.com/ - 3/7/2003
'This script may be freely distributed or modified

Const qPreview = "The Image Preview Extension is currently "
Const qPreviewEnabled = "enabled.  Turn it off?"
Const qPreviewDisabled = "disabled.  Turn it on?"

Const regRoot = "HKCR\SystemFileAssociations\image\ShellEx\ContextMenuHandlers\ShellImagePreview\"
Const regValue = "{e84fda7c-1d6a-45f6-b725-cb260c236066}"
Const regDataType = "REG_SZ"

Dim WSHShell
Dim errNum, isEnabled, question

Set WSHShell = WScript.CreateObject("WScript.Shell")

' Get the current state of the preview option
Err.Clear
On Error Resume Next
Call WSHShell.RegRead(regRoot)
errNum = Err.Number
On Error Goto 0

isEnabled = (errNum = 0)

If isEnabled Then
  question = qPreview & qPreviewEnabled
Else
  question = qPreview & qPreviewDisabled
End If

If MsgBox(question, 4, scriptName) = 6 Then
  If isEnabled Then
    ' The key is there; delete it to turn off Preview.
    Call WSHShell.RegDelete(regRoot)
  Else
    ' since the key's not there, add it back to turn on Preview.
    Call WSHShell.RegWrite(regRoot, regValue, regDataType)
  End If
End if
